require "ISUI/ISModalDialog"
require "luautils"

RecycleVehicleMenu = {}

-- ------------------------------------------------------
-- Copy of the same functions from ISBlacksmithMenu
-- for compatibility reasons
-- ------------------------------------------------------

local function comparatorDrainableUsesInt(item1, item2)
    return item1:getDrainableUsesInt() - item2:getDrainableUsesInt()
end

local function predicateDrainableUsesInt(item, count)
    return item:getDrainableUsesInt() >= count
end

local function getBlowTorchWithMostUses(container)
    return container:getBestTypeEvalRecurse("Base.BlowTorch", comparatorDrainableUsesInt)
end

local function getFirstBlowTorchWithUses(container, uses)
    return container:getFirstTypeEvalArgRecurse("Base.BlowTorch", predicateDrainableUsesInt, uses)
end

-- ------------------------------------------------------
-- The mod's functions
-- ------------------------------------------------------

local function onRecycleVehicleAux(player, button, vehicle, propaneNeeded)
    if button.internal == "NO" then return end

    if luautils.walkAdj(player, vehicle:getSquare()) then
        local blowTorch = getFirstBlowTorchWithUses(player:getInventory(), propaneNeeded)
        ISWorldObjectContextMenu.equip(player, player:getPrimaryHandItem(), blowTorch, true);
        local mask = player:getInventory():getFirstTypeRecurse("WeldingMask")
        if mask then
            ISInventoryPaneContextMenu.wearItem(mask, player:getPlayerNum())
        end
        ISTimedActionQueue.add(RecycleVehicleAction:new(player, vehicle, propaneNeeded))
    end
end

local function onRecycleVehicle(player, vehicle, propaneNeeded)
    local message = getText("IGUI_VehicleRecycling_ConfirmDialog_Vehicle")
    if vehicle:getScript():getName():find("Trailer") then
        message = getText("IGUI_VehicleRecycling_ConfirmDialog_Trailer")
    end

    local playerNum = player:getPlayerNum()
    local modal = ISModalDialog:new(0, 0, 350, 150, message, true, player, onRecycleVehicleAux, playerNum, vehicle, propaneNeeded)
    modal:initialise();
    modal:addToUIManager();
end

function RecycleVehicleMenu.addOptionToMenuOutsideVehicle(player, context, vehicle)
    if vehicle:getScript():getName():match("Burnt") then return end
    if not player:getInventory():containsTypeRecurse("BlowTorch") then return end

    local propaneNeeded = 0
    for i = 1, vehicle:getPartCount() do
        local part = vehicle:getPartByIndex(i - 1)
        local partId = part:getId()

        if not (part:getItemType() and not part:getItemType():isEmpty() and not part:getInventoryItem()) then
            if not (partId:find("Wind") or partId:find("Headlight") or partId:find("TruckBed")
                    or partId:find("GloveBox") or partId:find("Engine") or partId:find("Heater")
                    or partId:find("PassengerCompartment") or partId == "TrunkDoorWreck") then
                propaneNeeded = propaneNeeded + 0.65
            end
        end
    end

    propaneNeeded = math.ceil(propaneNeeded) + RecycleVehicleAction.getBaseArea(vehicle)

    local optionText = getText("ContextMenu_VehicleRecycling_RemoveVehicle")
    if vehicle:getScript():getName():find("Trailer") then
        optionText = getText("ContextMenu_VehicleRecycling_RemoveTrailer")
    end

    local option = context:addOption(optionText, player, onRecycleVehicle, vehicle, propaneNeeded);
    local toolTip = ISToolTip:new();
    toolTip:initialise();
    toolTip:setVisible(false);
    option.toolTip = toolTip;
    toolTip:setName(optionText);
    toolTip.description = getText("Tooltip_VehicleRecycling") .. " <LINE> <LINE> ";

    if player:getInventory():containsTypeRecurse("WeldingMask") then
        toolTip.description = toolTip.description .. " <LINE> <RGB:1,1,1> " .. getItemNameFromFullType("Base.WeldingMask");
    else
        toolTip.description = toolTip.description .. " <LINE> <RGB:1,0,0> " .. getItemNameFromFullType("Base.WeldingMask");
        option.notAvailable = true;
    end

    local blowTorch = getBlowTorchWithMostUses(player:getInventory())
    if blowTorch then
        local blowTorchUsesLeft = blowTorch:getDrainableUsesInt();
        if blowTorchUsesLeft >= propaneNeeded then
            toolTip.description = toolTip.description .. " <LINE> <RGB:1,1,1> " .. getItemNameFromFullType("Base.BlowTorch") .. " " .. getText("ContextMenu_Uses") .. " " .. blowTorchUsesLeft .. "/" .. propaneNeeded;
        else
            toolTip.description = toolTip.description .. " <LINE> <RGB:1,0,0> " .. getItemNameFromFullType("Base.BlowTorch") .. " " .. getText("ContextMenu_Uses") .. " " .. blowTorchUsesLeft .. "/" .. propaneNeeded;
            option.notAvailable = true;
        end
    else
        toolTip.description = toolTip.description .. " <LINE> <RGB:1,0,0> " .. getItemNameFromFullType("Base.BlowTorch") .. " 0/" .. propaneNeeded;
        option.notAvailable = true;
    end
end

-- Wrap the original function
if not RecycleVehicleMenu.defaultMenuOutsideVehicle then
    RecycleVehicleMenu.defaultMenuOutsideVehicle = ISVehicleMenu.FillMenuOutsideVehicle
end

-- Override the original function
function ISVehicleMenu.FillMenuOutsideVehicle(player, context, vehicle, test)
    RecycleVehicleMenu.defaultMenuOutsideVehicle(player, context, vehicle, test)
    RecycleVehicleMenu.addOptionToMenuOutsideVehicle(getSpecificPlayer(player), context, vehicle)
end